<?php

/** @noinspection PhpUndefinedMethodInspection */

namespace DefStudio\GameEngine\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;
use DefStudio\GameEngine\Database\Factories\Concerns\DefinesAwards;
use DefStudio\GameEngine\Database\Factories\Concerns\HasStorytelling;

class StoryFactory extends Factory
{
    use HasStorytelling;
    use DefinesAwards;

    public function modelName(): string
    {
        return \game_engine()->storyClass();
    }

    public function definition(): array
    {
        return [
            'title' => fake()->sentence(),
            'description' => fake()->text,
            'organization_id' => game_engine()->organizationClass()::factory(),
            'published_at' => null,
        ];
    }

    public function published(Carbon $when = null): StoryFactory
    {
        return $this->state([
            'published_at' => $when ?? carbon('2023-01-01'),
        ]);
    }
}
