<?php

use Illuminate\Support\Facades\Route;
use DefStudio\GameEngine\Middleware\AdminMiddleware;
use DefStudio\GameEngine\Http\Controllers\MapsController;
use DefStudio\GameEngine\Http\Controllers\RunsController;
use DefStudio\GameEngine\Http\Controllers\TeamsController;
use DefStudio\GameEngine\Http\Controllers\UsersController;
use Laravel\Jetstream\Http\Middleware\AuthenticateSession;
use DefStudio\GameEngine\Http\Controllers\AwardsController;
use DefStudio\GameEngine\Http\Controllers\StoriesController;
use DefStudio\GameEngine\Http\Controllers\OrganizationsController;

Route::middleware(['web', 'auth:sanctum', AuthenticateSession::class, 'verified'])->group(function() {

    Route::name('game-engine.')->prefix(config('game-engine.route_prefix') ?? '')->group(function() {
        Route::get('dashboard', fn() => view('game-engine::dashboard'))->name('dashboard');

        Route::get('play/{story_id}', [RunsController::class, 'play'])->name('play');

        Route::get('organizations/{organization}/switch', [OrganizationsController::class, 'switch'])->name('organizations.switch');

        Route::name('admin.')->prefix('admin')->middleware(AdminMiddleware::class)->group(function() {
            Route::get('users/create', [UsersController::class, 'create'])->name('users.create');
            Route::resource('users', UsersController::class)->only(['index', 'edit']);

            Route::resource('organizations', OrganizationsController::class)->only(['index', 'create', 'edit']);

            Route::resource('teams', TeamsController::class)->only(['index', 'create', 'edit']);

            Route::resource('stories', StoriesController::class)->only(['index', 'create', 'edit']);

            Route::get('stories/{story}/maps/{map}/edit', [MapsController::class, 'edit'])->name('maps.edit');

            Route::resource('awards', AwardsController::class)->only(['index']);
        });
    });
});
