<?php

namespace DefStudio\GameEngine\Decorators\Runs;

use DefStudio\GameEngine\Models\Map;
use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Decorators\ModelDecorator;

/**
 * @extends ModelDecorator<Map>
 *
 * @mixin Map
 */
class PlayableMap extends ModelDecorator
{
    private Run $run;

    protected function setup_decorator(): void
    {
        $this->model->loadMissing(['media', 'storytellings', 'missions']);
    }

    public function setup(Run $run): self
    {
        $this->run = $run;

        return $this;
    }

    public function completed(): bool
    {
        return $this->missions->every(fn(Mission $mission) => PlayableMission::build($mission)->setup($this->run)->completed());
    }
}
