<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use Illuminate\Contracts\View\View;
use DefStudio\GameEngine\Models\Organization;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use function game_engine;

class MapsController
{
    use AuthorizesRequests;

    public function edit(int $story, int $map): View
    {
        /** @var Organization $organization */
        $organization = game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);
        $story = $organization->stories()->findOrFail($story);
        $map = $story->maps()->findOrFail($map);

        $this->authorize('update', $story);

        return view('game-engine::admin.maps.edit', ['map' => $map]);
    }
}
