<?php

use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Enums\Feature;

?>


@props(['story'])

@php($user = game_engine()->user())

<x-card :padding="false">
    <x-slot name="header">
        {{$story->title}}
    </x-slot>

    @if($cover_url = $story->getFirstMediaUrl(\DefStudio\GameEngine\Enums\MediaCollection::cover, \DefStudio\GameEngine\Enums\MediaConversion::square))
        <img class="w-full" src="{{$cover_url}}">
    @endif

    <x-slot name="actions">
        @if( $user->is_playing_story($story))
            <x-link href="{{route('game-engine.play', $story)}}">{{__('Continue')}}</x-link>
        @elseif($user->completed_story($story))
            @if($user->hasRole(Role::super_admin) || Feature::allow_replay->enabled())
                <x-link href="{{route('game-engine.play', $story)}}">{{__('Replay')}}</x-link>
            @else
                {{('Completed')}}
            @endif
        @else
            <x-link href="{{route('game-engine.play', $story)}}">{{__('Play')}}</x-link>
        @endif
    </x-slot>
</x-card>
