<?php
/** @var \DefStudio\GameEngine\Models\Story $model */
/** @var \DefStudio\GameEngine\Models\Contracts\SubscribesToStories $subscriber */
?>

<div class="flex">
    @can('update', $subscriber)
        @if($subscriber->is_subscribed_to_story($model))
            <x-button color="secondary" wire:click="unsubscribe({{$model->id}})" wire:loading.disable>{{__('Unsubscribe')}}</x-button>
        @else
            <x-button wire:click="subscribe({{$model->id}})" wire:loading.disable>{{__('Subscribe')}}</x-button>
        @endif
    @endcan
</div>
