@php
    use DefStudio\GameEngine\Http\Livewire\Runs\Concerns\RunsTasks;
    use DefStudio\GameEngine\Decorators\Runs\PlayableTask;
    use DefStudio\GameEngine\Decorators\Tasks\DragAndDrop;

    /** @var RunsTasks $this */

   /** @var PlayableTask&DragAndDrop $task */
    $task = $this->task;

    $task->loadMissing('media');

    $tiles = $task->should_randomize_tiles_order()
        ? collect($task->tiles())->shuffle()->toArray()
        : $task->tiles()
@endphp

<div class="flex flex-col items-center" id="drag-and-drop" wire:ignore>
    <div class="ck-content">
        {!! localize($task->question()) !!}
    </div>

    <div class=" flex flex-col mt-4"
         x-data="task_drag_and_drop_run"
         x-init="initialize({snaps: {{json_encode($task->snaps())}}, options: {{json_encode($task->run_options())}} })"
         @resize.window="update_zoom"

         wire:key="task-{{$task->id}}"
    >
        <div class="mx-auto relative" x-ref="container" wire:key="drag-and-drop-image-container">
            <img src="{{$task->getFirstMediaUrl('base_image')}}" x-ref="base_image" :style="size.zoom ? `width: ${size.w * size.zoom }px; height: ${size.h * size.zoom }px;` : ``">
        </div>


        <div class="my-4 px-8 flex flex-wrap justify-center">
            @foreach($tiles as $tile_data)
                <img src="{{$task->media->find($tile_data['media_id'])?->getUrl()}}"
                     id="draggable_tile_{{$tile_data['id']}}"
                     wire:key="draggable_tile_{{$tile_data['id']}}"
                     class="cursor-pointer hover:opacity-90 origin-top-left"
                     :style="placements['{{$tile_data['id']}}'] ? `position: absolute; left: ${placements['{{$tile_data['id']}}'].x * size.zoom}px; top: ${placements['{{$tile_data['id']}}'].y * size.zoom}px; scale: ${size.zoom};` : `scale: ${size.zoom};`"
                     x-bind:draggable="!submitting"
                     @dragstart="drag_start(event)"
                     @dragend="drag_end('{{$tile_data['id']}}', event)"
                >
            @endforeach

        </div>

        <div class="flex">
            @if($task->is_partial_submit_allowed())
                <x-game-engine::tasks.submit-button x-show="check_complete()"
                                                    @click="submit"
                                                    class="ml-auto"
                                                    x-bind:class="{'opacity-50': submitting}"
                                                    x-bind:disabled="submitting"
                >{{__('Submit answer')}}</x-game-engine::tasks.submit-button>
            @endif
        </div>
    </div>
</div>
