<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Maps;

use DefStudio\Actions\Action;
use Illuminate\Http\UploadedFile;
use DefStudio\GameEngine\Models\Map;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Maps\MapBackgroundUpdated;

/**
 * @method static void run(Map $map, UploadedFile $background_image_file)
 */
class StoreBackgroundImage extends Action
{
    public function handle(Map $map, UploadedFile $background_image_file): void
    {
        Gate::authorize('update', $map);

        $map->addMedia($background_image_file)
            ->toMediaCollection(MediaCollection::background->name);

        MapBackgroundUpdated::dispatch($map);
    }
}
