@php
    /** @var \DefStudio\GameEngine\Models\Story $story */
@endphp
<x-app-layout>
    <x-slot name="header">
        @isset($story)
            {{__('Edit Story :title', ['title' => $story->title])}}
        @else
            {{__('Create Story')}}
        @endif
    </x-slot>

    <x-slot name="actions">
        <x-link class="ml-auto" :href="\game_engine()->back_url()" icon="arrow-sm-left" color="secondary" size="sm">{{__('Back')}}</x-link>
    </x-slot>

    <x-container>
        <livewire:game-engine.admin.stories.edit :story="$story ?? \game_engine()->storyQuery()->make()"/>
    </x-container>

    @isset($story)
        <x-container class="mt-4">
            <livewire:game-engine.admin.stories.maps :story="$story"/>
        </x-container>

        <x-container class="mt-4">
            <x-game-engine::storytellings.manager :target="$story"/>
        </x-container>

        <x-container class="mt-4">
            <x-game-engine::awards.manager :scope="$story"/>
        </x-container>
    @endif


</x-app-layout>
