<x-card>
    @if($isModal)
        <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
            @if($user->exists)
                {{__('Edit User')}}
            @else
                {{__('Create User')}}
            @endif
        </x-slot>
    @endif


    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
        <x-text model="user.name" defer :label="__('Name')"/>
        <x-text model="user.email" defer :label="__('Email')"/>

        @feature(\DefStudio\GameEngine\Enums\Feature::multi_language)
        <x-select model="user.locale" defer :options="$available_locales" :label="__('Language')"/>
        @endfeature
    </div>

    @feature(\DefStudio\GameEngine\Enums\Feature::reset_password)
    @if($user->exists && $user->password === null)
        <div class="mt-5">
            {{__('Password reset URL')}}: <br> <a href="{{$user->password_reset_url()}}">{{$user->password_reset_url()}}</a>
        </div>
    @endif
    @endfeature

    @if(!$user->exists && $user->email && $existing_user = game_engine()->userQuery()->where('email', $user->email)->first())
        <div class="mt-2 grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <div></div>
            <x-button wire:click="switch_to_user({{$existing_user->id}})">{{__('Switch to user :name', ['name' => $existing_user->name])}}</x-button>
            <div></div>
        </div>
    @endif

    <x-slot name="actions">
        @if($this->isModal)
            <x-button class="mr-auto" wire:loading.disable color="secondary" wire:click="$emit('closeModal')">{{__('Abort')}}</x-button>
        @endif
        <x-button wire:loading.disable wire:click="save">{{__('Save')}}</x-button>
    </x-slot>
</x-card>
