@php
    use DefStudio\GameEngine\Models\Run;
    use DefStudio\GameEngine\Decorators\Runs\PlayableStory;
    use DefStudio\GameEngine\Decorators\Runs\PlayableMap;
    use DefStudio\GameEngine\Decorators\Runs\PlayableMission;
    use DefStudio\GameEngine\Decorators\Runs\PlayableTask;

        /** @var Run $run */
@endphp

<x-card>
    @if($isModal)
        <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
            {{__('Run report for :user', ['user' => $run->user->name])}}

            <div wire:click="$emit('closeModal')" class="absolute top-3 right-3 w-6 h-6 rounded-md border shadow bg-gray-50 hover:bg-gray-100 active:bg-gray-200 flex justify-center items-center cursor-pointer">
                <x-icon size="4" name="x"/>
            </div>
        </x-slot>
    @endif

    <div>
        <div>
            {{__('Status')}}:
            @if($run->story->completed_at)
                {{__('Completed')}}
            @else
                {{__('Ongoing')}}
            @endif
        </div>
    </div>

    @php($snapshot = $run->snapshot)

    <table x-data="{}" class="min-w-full">
        <thead class="bg-gray-50 uppercase font-medium whitespace-nowrap tracking-wider text-left text-gray-500 text-xs">
        <tr>
            <th class="px-2 relative py-1" scope="col">
                {{'Activity'}}
            </th>
            <th class="px-2 relative py-1" scope="col">
                {{'Time Spent'}}
            </th>
            <x-game-engine::livewire.runs.view.table.award-headers class="px-2 relative py-1" :awards="$snapshot['awards']"/>
        </tr>
        </thead>
        <tbody>
        @php($story = $snapshot['story'])
        <x-game-engine::livewire.runs.view.table.row
            :label="__('Total')"
            :activity="$story"
            :run='$run'
            :awards="$snapshot['awards']"
            :state_key="PlayableStory::$state_key"
            bgcolor="bg-blue-800"
        />

        @foreach($story['maps'] ?? [] as $map)
            <x-game-engine::livewire.runs.view.table.row
                :label="trans_choice('Map|Maps', 1)"
                :activity="$map"
                :run='$run'
                :awards="$snapshot['awards']"
                :state_key="PlayableMap::$state_key"
                bgcolor="bg-blue-600"
                padding="4"
           />

            @foreach($map['missions'] ?? [] as $mission)
                <x-game-engine::livewire.runs.view.table.row
                    :label="trans_choice('Mission|Missions', 1)"
                    :activity="$mission"
                    :run='$run'
                    :awards="$snapshot['awards']"
                    :state_key="PlayableMission::$state_key"
                    bgcolor="bg-blue-400"
                    padding="8"
                />

                @foreach($mission['tasks'] ?? [] as $task)
                    <x-game-engine::livewire.runs.view.table.row
                        :label="$task['type']::type_label()"
                        :activity="$task"
                        :run='$run'
                        :awards="$snapshot['awards']"
                        :state_key="PlayableTask::$state_key"
                        bgcolor="bg-blue-200"
                        padding="12"
                    />

                @endforeach
            @endforeach
        @endforeach

        </tbody>
    </table>
</x-card>
