<?php

/** @noinspection PhpUndefinedMethodInspection */

namespace DefStudio\GameEngine\Database\Factories;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Factories\Factory;

class RunFactory extends Factory
{
    public function modelName(): string
    {
        return game_engine()->runClass();
    }

    public function definition(): array
    {
        return [
            'story_id' => game_engine()->storyClass()::factory(),
            'user_id' => game_engine()->userClass()::factory(),
        ];
    }

    public function completed(Carbon $at = null): RunFactory
    {
        return $this->state(['completed_at' => $at ?? now()]);
    }
}
