<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

namespace DefStudio\GameEngine\Providers;

use Livewire\Livewire;
use Illuminate\Support\ServiceProvider;
use DefStudio\GameEngine\Http\Livewire\Runs\Runner;
use DefStudio\GameEngine\Http\Livewire\Awards\AwardList;
use DefStudio\GameEngine\Http\Livewire\Users\ResetPassword;
use DefStudio\GameEngine\Http\Livewire\Maps\Edit as EditMap;
use DefStudio\GameEngine\Http\Livewire\Runs\View as ViewRun;
use DefStudio\GameEngine\Http\Livewire\Tasks\Edit as EditTask;
use DefStudio\GameEngine\Http\Livewire\Teams\Edit as EditTeam;
use DefStudio\GameEngine\Http\Livewire\Users\Edit as EditUser;
use DefStudio\GameEngine\Http\Livewire\Runs\Table as RunsTable;
use DefStudio\GameEngine\Http\Livewire\Awards\Edit as EditAward;
use DefStudio\GameEngine\Http\Livewire\Maps\Editor as MapEditor;
use DefStudio\GameEngine\Http\Livewire\Stories\Edit as EditStory;
use DefStudio\GameEngine\Http\Livewire\Stories\Maps as StoryMaps;
use DefStudio\GameEngine\Http\Livewire\Teams\Table as TeamsTable;
use DefStudio\GameEngine\Http\Livewire\Users\Table as UsersTable;
use DefStudio\GameEngine\Http\Livewire\Missions\Edit as EditMission;
use DefStudio\GameEngine\Http\Livewire\Stories\Table as StoriesTable;
use DefStudio\GameEngine\Http\Livewire\Runs\MissionModal as RunnerMission;
use DefStudio\GameEngine\Http\Livewire\Teams\UsersTable as TeamUsersTable;
use DefStudio\GameEngine\Http\Livewire\Organizations\Edit as EditOrganization;
use DefStudio\GameEngine\Http\Livewire\Storytellings\Edit as EditStorytelling;
use DefStudio\GameEngine\Http\Livewire\Teams\StoriesTable as TeamStoriesTable;
use DefStudio\GameEngine\Http\Livewire\Users\StoriesTable as UserStoriesTable;
use DefStudio\GameEngine\Http\Livewire\Organizations\Table as OrganizationsTable;
use DefStudio\GameEngine\Http\Livewire\Runs\StorytellingModal as RunnerStorytelling;
use DefStudio\GameEngine\Http\Livewire\Storytellings\Manager as StorytellingManager;
use DefStudio\GameEngine\Http\Livewire\Organizations\UsersTable as OrganizationUsersTable;

class LivewireServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        Livewire::component('game-engine.users.reset-password', ResetPassword::class);
        Livewire::component('game-engine.admin.users.edit', EditUser::class);
        Livewire::component('game-engine.admin.users.table', UsersTable::class);
        Livewire::component('game-engine.admin.users.stories.table', UserStoriesTable::class);
        Livewire::component('game-engine.admin.organizations.table', OrganizationsTable::class);
        Livewire::component('game-engine.admin.organizations.edit', EditOrganization::class);
        Livewire::component('game-engine.admin.organizations.users.table', OrganizationUsersTable::class);
        Livewire::component('game-engine.admin.teams.table', TeamsTable::class);
        Livewire::component('game-engine.admin.teams.edit', EditTeam::class);
        Livewire::component('game-engine.admin.teams.users.table', TeamUsersTable::class);
        Livewire::component('game-engine.admin.teams.stories.table', TeamStoriesTable::class);
        Livewire::component('game-engine.admin.stories.table', StoriesTable::class);
        Livewire::component('game-engine.admin.stories.edit', EditStory::class);
        Livewire::component('game-engine.admin.stories.maps', StoryMaps::class);
        Livewire::component('game-engine.admin.maps.edit', EditMap::class);
        Livewire::component('game-engine.admin.maps.editor', MapEditor::class);
        Livewire::component('game-engine.admin.missions.edit', EditMission::class);
        Livewire::component('game-engine.admin.tasks.edit', EditTask::class);
        Livewire::component('game-engine.admin.storytelling.manager', StorytellingManager::class);
        Livewire::component('game-engine.admin.storytelling.edit', EditStorytelling::class);
        Livewire::component('game-engine.admin.awards.award-list', AwardList::class);
        Livewire::component('game-engine.admin.awards.edit', EditAward::class);
        Livewire::component('game-engine.admin.runs.table', RunsTable::class);
        Livewire::component('game-engine.admin.runs.view', ViewRun::class);
        Livewire::component('game-engine.runner', Runner::class);
        Livewire::component('game-engine.runner.mission', RunnerMission::class);
        Livewire::component('game-engine.runner.storytelling', RunnerStorytelling::class);
    }
}
