<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

namespace DefStudio\GameEngine\Http\Livewire\Runs;

use DefStudio\GameEngine\Models\Run;
use Illuminate\Support\Facades\Gate;
use LivewireUI\Modal\ModalComponent;
use DefStudio\GameEngine\Http\Livewire\Concerns\ImprovedModal;

class View extends ModalComponent
{
    use ImprovedModal;

    /** @var Run */
    public $run;

    public static function modalMaxWidth(): string
    {
        return '7xl';
    }

    public function mount(int $run_id): void
    {
        $this->run = game_engine()->runQuery()->findOrFail($run_id);

        Gate::authorize('view', $this->run);
    }

    public function render(): \Illuminate\Contracts\View\View
    {
        return view('game-engine::livewire.admin.runs.view');
    }
}
