@php
    use DefStudio\GameEngine\Enums\MediaCollection;use DefStudio\GameEngine\Enums\MediaConversion;use DefStudio\GameEngine\Models\Contracts\WithStorytelling;use Illuminate\Database\Eloquent\Model;

    /** @var WithStorytelling&Model $target */
@endphp

<x-card :collapsed="true">
    <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
        <x-icon name="book-open"/>&nbsp;{{trans_choice('Storytellings|Storytelling', 2)}}
    </x-slot>

    <div class="flex flex-col gap-3">
        @forelse($target->storytellings->loadMissing('target') as $storytelling)
            <x-card>
                <div class="flex gap-3">
                    @if($background_url = $storytelling->getFirstMediaUrl(MediaCollection::background, MediaConversion::thumb))
                        <img class="mb-auto" src="{{$background_url}}">
                    @endif
                    <div class="grow">
                        <span class="bg-gray-200 rounded py-1 px-2 mb-1">{{$storytelling->type->label()}}</span> {!! $storytelling->localized_text() !!}
                    </div>
                    @can('update', $storytelling)
                        <x-button class="my-auto" size="sm" color="secondary" icon="pencil"
                                  wire:click="$emit('openModal', 'game-engine.admin.storytelling.edit', {{json_encode(['isModal' => true, 'storytelling_id' => $storytelling->id])}})"
                        />
                    @endcan
                    @can('delete', $storytelling)
                        <x-confirm-action class="ml-2 my-auto" title="Warning"
                                          :content="__('Do you really want to delete this storytelling?')"
                                          :requires-password="true"
                                          wire:then="delete({{$storytelling->id}})"
                        >
                            <x-button icon="trash" color="secondary" size="sm"/>
                        </x-confirm-action>
                    @endcan
                </div>
            </x-card>
        @empty
            {{__('No storytelling yet...')}}
        @endforelse
    </div>


    <x-slot name="actions">
        <div class="flex justify-between w-full">
            @foreach(\DefStudio\GameEngine\Enums\StorytellingType::cases() as $storytelling_type)
                <x-button wire:loading.disable
                          wire:click="$emit('openModal', 'game-engine.admin.storytelling.edit', {{json_encode(['isModal' => true, 'target_id' => $target->id, 'target_type' => $target->getMorphClass(), 'type' => $storytelling_type])}})"
                          color="secondary"
                          icon="plus"
                >{{$storytelling_type->label()}}</x-button>
            @endforeach
        </div>
    </x-slot>
</x-card>
