@php
    /** @var \DefStudio\GameEngine\Models\Map $map */
@endphp

<x-app-layout>
    <x-slot name="header">
        {{__('Edit Map :title', ['title' => $map->title])}}
    </x-slot>

    <x-slot name="actions">
        <x-link class="ml-auto" :href="route('game-engine.admin.stories.edit', $map->story)" icon="arrow-sm-left" color="secondary" size="sm">{{__('Back')}}</x-link>
    </x-slot>

    <x-container>
        <livewire:game-engine.admin.maps.edit :map="$map"/>
    </x-container>

    <x-container class="mt-4">
        <livewire:game-engine.admin.maps.editor :map="$map"/>
    </x-container>

    <x-container class="mt-4">
        <x-game-engine::storytellings.manager :target="$map"/>
    </x-container>

    <x-container class="mt-4">
        <x-game-engine::awards.manager :scope="$map"/>
    </x-container>
</x-app-layout>
