<?php

namespace DefStudio\GameEngine\Actions\Missions;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Events\Missions\MissionSaved;
use DefStudio\GameEngine\Events\Missions\MissionUpdated;

/**
 * @method static Mission run(Mission $mission)
 */
class UpdateMission extends Action
{
    public function handle(Mission $mission): Mission
    {
        Gate::authorize('update', $mission);

        $mission->save();

        MissionUpdated::dispatch($mission);
        MissionSaved::dispatch($mission);

        return $mission;
    }
}
