<?php

namespace DefStudio\GameEngine\Exceptions;

use Exception;
use DefStudio\GameEngine\Enums\Role;

class TeamException extends Exception
{
    public static function missing_organization(): TeamException
    {
        return new self('A team must have an organization');
    }

    public static function invalid_role(?Role $role): TeamException
    {
        $role_label = $role?->label() ?? 'guest';

        return new self("[$role_label] is not a valid role for a Team");
    }

    public static function already_subscribed(): TeamException
    {
        return new self('Cannot subscribe a user twice to a team');
    }

    public static function team_membership_failure(): TeamException
    {
        return new self('User does not belongs to this team');
    }
}
