<?php

/** @noinspection PhpUndefinedMethodInspection */

namespace DefStudio\GameEngine\Database\Factories;

use Illuminate\Database\Eloquent\Factories\Factory;
use DefStudio\GameEngine\Decorators\Tasks\DragAndDrop;
use DefStudio\GameEngine\Database\Factories\Concerns\HasMedia;
use DefStudio\GameEngine\Decorators\Tasks\MultipleChoiceQuestion;
use DefStudio\GameEngine\Database\Factories\Concerns\HasStorytelling;
use function game_engine;

class TaskFactory extends Factory
{
    use HasMedia;
    use HasStorytelling;

    public function modelName(): string
    {
        return game_engine()->taskClass();
    }

    public function definition(): array
    {
        return [
            'title' => fake()->sentence,
            'mission_id' => game_engine()->missionClass()::factory(),
            'type' => fake()->randomElement([MultipleChoiceQuestion::class, DragAndDrop::class]),
        ];
    }

    public function type(string $decorator): TaskFactory
    {
        return $this->state([
            'type' => $decorator,
        ]);
    }
}
