@php
    use DefStudio\GameEngine\Models\Award;
    use DefStudio\GameEngine\Enums\MediaCollection;
    use DefStudio\GameEngine\Enums\MediaConversion;

    /** @var Award $award */
@endphp

<x-card>
    @if($isModal)
        <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
            @if($award->parent_id === null)
                @if($award->exists)
                    {{__('Edit Award')}}
                @else
                    {{__('Create Award')}}
                @endif
            @else
                @if($award->exists)
                    {{__('Edit Child Award for: :parent_award',  ['parent_award'=> $award->parent->name])}}
                @else
                    {{__('Create Child Award for: :parent_award',  ['parent_award'=> $award->parent->name])}}
                @endif
            @endif
        </x-slot>
    @endif


    <div @class(["grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6"])>

        <x-text model="award.name" :label="__('Name')" defer/>

        <x-text-area class="col-span-1 md:col-span-2 lg:col-span-3" model="award.description" :label="__('Description')" defer/>

        <div class="col-span-1 md:col-span-2 lg:col-span-3 space-y-6">
            <x-game-engine::livewire.image_field
                id="icon-image"
                model="icon_image"
                :label="trans_choice('Icon Image|Icon Images', 1)"
                :uploaded-url="$this->award->getFirstMediaUrl(MediaCollection::icon, MediaConversion::thumb)"
                :helper="__('SVG, PNG or JPG')"
                remove-method="remove_icon_image"
            />
        </div>

        @if($award->exists && $award->parent_id === null)
            <x-game-engine::elements.labeled-box class="col-span-1 md:col-span-2 lg:col-span-3" :label="trans_choice('Child Award|Child Awards', 2)">
                <livewire:game-engine.admin.awards.award-list wire:key="award-list"  class="col-span-1 md:col-span-2 lg:col-span-3" :parent="$award"/>
            </x-game-engine::elements.labeled-box>
        @endif

    </div>

    <x-slot name="actions">
        @if($this->isModal)
            <x-button class="mr-auto" wire:loading.disable color="secondary" wire:click="$emit('closeModal')">
                @if($award->isDirty())
                    {{__('Abort')}}
                @else
                    {{__('Close')}}
                @endif
            </x-button>
        @endif

        <x-button wire:loading.disable wire:click="save">{{__('Save')}}</x-button>
    </x-slot>
</x-card>

