<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Missions;

use DefStudio\Actions\Action;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\DTO\Missions\Placeholder;
use DefStudio\GameEngine\Exceptions\MissionException;

/**
 * @method static bool run(Mission $mission, Placeholder $placeholder)
 */
class UpdateMissionFromPlaceholder extends Action
{
    public function handle(Mission $mission, Placeholder $placeholder): bool
    {
        throw_if($mission->id !== $placeholder->id, MissionException::invalid_placeholder());

        $mission->pos_x = $placeholder->pos_x;
        $mission->pos_y = $placeholder->pos_y;

        if ($mission->isDirty()) {
            UpdateMission::run($mission);

            return true;
        }

        return false;
    }
}
