@php
    use DefStudio\GameEngine\Http\Livewire\Runs\Concerns\RunsTasks;
    use DefStudio\GameEngine\Decorators\Runs\PlayableTask;
    use DefStudio\GameEngine\Decorators\Tasks\MultipleChoiceQuestion;

    /** @var RunsTasks $this */

    /** @var PlayableTask&MultipleChoiceQuestion $task */
    $task = $this->task;

    if(empty($this->get_task_state('available_answers'))){
        $answers = $task->answers();

        if($task->should_randomize_answers_order()){
            $answers = collect($answers)->shuffle()->toArray();
        }

        $this->set_task_state('available_answers', $answers);
    }
@endphp

<div>
    <div class="ck-content">
        {!! $task->question() !!}
    </div>

    <div class="my-4 px-8 flex flex-wrap justify-center gap-4">
        @foreach($this->get_task_state('available_answers') as $answer)
            <x-game-engine::tasks.multiple-choice-question.answer-button
                wire:click="complete_task_with_result({{json_encode(['answer' => $answer['id']])}})"
                wire:loading.attr="disabled"
            >
                {!! $answer['answer'] !!}
            </x-game-engine::tasks.multiple-choice-question.answer-button>
        @endforeach
    </div>
</div>
