@php
    use DefStudio\GameEngine\Enums\Permission;
    use DefStudio\GameEngine\Enums\Role;
@endphp
<x-card>
    <div @class([
            "grid grid-cols-1",
            'gap-6' => $editing
        ])>
        <div @class([
            "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 ",
            'gap-6' => $editing
        ])>
            @if($editing)
                <x-checkbox model="published" defer :label="__('Published')"/>
            @else
                @if($published)
                    {{__('Published')}}
                @else
                    {{__('Unpublished')}}
                @endif
            @endif

        </div>
        <div @class([
            "grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 ",
            'gap-6' => $editing
        ])>
            @if($editing)
                <x-text model="story.title" defer :label="__('Title')"/>
                <x-text-area class="col-span-1 lg:col-span-3" model="story.description" defer :label="__('Description')"/>
            @else
                <h2 class="text-xl text-gray-700">{{$story->title}}</h2>
                <div class="text-gray-500 col-span-1 lg:col-span-3">{{$story->description}}</div>
            @endif
        </div>
    </div>


    <x-slot name="actions">
        @if($editing)
            <x-button wire:loading.disable wire:click="save">{{__('Save')}}</x-button>
        @else
            <x-button wire:loading.disable wire:click="$set('editing', true)" color="secondary">{{__('Edit')}}</x-button>
        @endif
    </x-slot>
</x-card>
