@php
    use DefStudio\GameEngine\Models\Run;
    use DefStudio\GameEngine\Http\Livewire\Runs\Runner;
    use DefStudio\GameEngine\Enums\StorytellingType;
    use DefStudio\GameEngine\Enums\Role;

    /** @var Runner $this */
    /** @var Run $run */
@endphp


<div wire:init="start">

    @if(game_engine()->user()->hasRole(Role::super_admin->value))
        <div class="fixed top-4 right-4 z-50">
            <x-button color="danger" wire:click="reset_run" wire:loading.disable>{{__('Reset Run')}}</x-button>
        </div>
    @endif

    @if($this->run->get_state('map.index', -1) >= 0)
        <x-game-engine::runs.map.main/>
    @endif
</div>
