@php
    use DefStudio\GameEngine\Http\Livewire\Runs\MissionModal;
    use DefStudio\GameEngine\Enums\StorytellingType;

    /** @var MissionModal $this */
@endphp
<div wire:init="start" class="relative px-2 py-2">

    @if($this->current_storytellings !== [])
        <div class=" inset-0">
            <livewire:game-engine.runner.storytelling :scope="$this->current_storytellings['scope']"
                                                      :type="$this->current_storytellings['type']"
                                                      :storytelling_ids="$this->current_storytellings['storytelling_ids']"
            />
        </div>
    @elseif($this->is_task_active())
        <x-dynamic-component :component="$this->task->model::run_component()"/>
    @endif
</div>
