<?php

namespace DefStudio\GameEngine\Exceptions;

use Exception;
use DefStudio\GameEngine\Models\Map;
use DefStudio\GameEngine\Models\Task;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Decorators\Runs\PlayableMap;
use DefStudio\GameEngine\Decorators\Runs\PlayableTask;
use DefStudio\GameEngine\Decorators\Tasks\TaskDecorator;
use DefStudio\GameEngine\Decorators\Runs\PlayableMission;

class RunnerException extends Exception
{
    public static function no_active_mission(): RunnerException
    {
        return new RunnerException('Trying to access mission while none are active');
    }

    public static function no_active_map(): RunnerException
    {
        return new RunnerException('Trying to access map while none are active');
    }

    public static function incomplete_map(PlayableMap|Map $map): RunnerException
    {
        return new RunnerException("Map [$map->title] is not complete");
    }

    public static function incomplete_mission(PlayableMission|Mission $mission): RunnerException
    {
        return new RunnerException("Mission [$mission->title] is not complete");
    }

    public static function mission_not_active(PlayableMission|Mission $mission): RunnerException
    {
        return new RunnerException("Mission [$mission->title] is not active");
    }

    public static function no_active_task(): RunnerException
    {
        return new RunnerException('Trying to access task while none are active');
    }

    public static function incomplete_task(PlayableTask|TaskDecorator|Task $task): RunnerException
    {
        return new RunnerException("Task [$task->title] is not complete");
    }

    public static function cannot_append_state(string $key): RunnerException
    {
        return new RunnerException("Cannot append state to [$key]");
    }
}
