<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use Illuminate\Contracts\View\View;
use DefStudio\GameEngine\Enums\Permission;
use DefStudio\GameEngine\Models\Organization;
use DefStudio\GameEngine\Actions\Runs\GetActiveRun;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use function game_engine;

class RunsController
{
    use AuthorizesRequests;

    public function index(): View
    {

        $this->authorize(Permission::view_runs->value);

        return view('game-engine::admin.runs.index');
    }

    public function play(int $story): View
    {
        /** @var Organization $organization */
        $organization = game_engine()->organizationQuery()->findOrFail(game_engine()->user()->current_organization_id);
        $story = $organization->stories()->findOrFail($story);

        $this->authorize('play', $story);

        $run = GetActiveRun::make()->find_or_create($story, game_engine()->user());

        $this->authorize('play', $run);

        return view('game-engine::stories.play', ['run' => $run]);
    }
}
