<?php

namespace DefStudio\GameEngine\Http\Livewire\Concerns;

use Livewire\TemporaryUploadedFile;
use DefStudio\GameEngine\Actions\Tasks\StoreAssetImage;

trait UploadsAssetsFromEditor
{
    /** @var array<string, null|TemporaryUploadedFile> */
    public $image_assets = [];

    public function finalize_image_asset_upload(string $tag): ?array
    {
        if (empty($this->image_assets[$tag])) {
            return null;
        }

        $media = StoreAssetImage::run($this->task, $this->image_assets[$tag]);

        $this->emit('asset.uploaded', $tag);

        return [
            'media_id' => $media->id,
            'public_url' => $media->getUrl(),
        ];
    }
}
