<?php

/** @noinspection PhpDocSignatureIsNotCompleteInspection */

namespace DefStudio\GameEngine\Actions\Missions\Contracts;

use Illuminate\Support\Collection;
use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Models\Task;
use DefStudio\GameEngine\Models\Mission;

interface TaskExtractor
{
    /**
     * @return Collection<int, Task>
     */
    public function extract(Run $run, Mission $mission): Collection;

    /**
     * @return array<array-key, array{label: string, tags: array<array-key, string>}>
     */
    public function task_tags(): array;
}
