<?php

namespace DefStudio\GameEngine\Mail\User;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use DefStudio\GameEngine\Models\User;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Queue\SerializesModels;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Contracts\Queue\ShouldQueue;

class WelcomeEmail extends Mailable implements ShouldQueue
{
    use Queueable;
    use SerializesModels;

    public function __construct(public User $user, public string $password)
    {
    }

    public function envelope(): Envelope
    {
        return new Envelope(
            subject: __('Welcome to :app_name', ['app_name' => config('app.name')]),
        );
    }

    public function content(): Content
    {
        return new Content(
            markdown: 'game-engine::emails.user.welcome',
        );
    }
}
