@php

    use DefStudio\GameEngine\Enums\MediaCollection;
    use DefStudio\GameEngine\Models\Story;
    use DefStudio\GameEngine\Enums\MediaConversion;

    /** @var Story $story */
@endphp

<x-card>
    <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
        <x-icon name="map"/>&nbsp;{{trans_choice('Map|Maps', 2)}}
    </x-slot>

    <div wire:sortable="update_maps_order">
        @forelse($story->maps->sortBy(['order', 'id']) as $map)
            <div class="flex min-w-[350px] gap-5 mt-2 px-2 py-2 cursor-move rounded-md bg-gray-100 shadow"
                 wire:sortable.handle
                 wire:sortable.item="{{$map->id}}"
                 wire:key="map-{{$map->id}}"
            >
                <img class="h-16 w-16 rounded-lg"
                     src="{{$map->getFirstMediaUrl(MediaCollection::background, MediaConversion::thumb)}}"
                     alt="{{$map->title}}"
                >
                <div class="my-auto text-lg whitespace-nowrap text-gray-700">
                    {{$map->title}}
                </div>
                <div class="my-auto grow text-gray-500">
                    {{$map->description}}
                </div>
                <div class="my-auto whitespace-nowrap">
                    <x-link :href="route('game-engine.admin.maps.edit', ['story' => $story, 'map' => $map])" icon="pencil" size="sm" color="secondary"></x-link>
                    <x-confirm-action class="ml-auto" title="Warning"
                                      :content="__('Do you really want to delete this map?')"
                                      :requires-password="true"
                                      wire:then="delete_map({{$map->id}})"
                    >
                        <x-button icon="trash" color="secondary" size="sm"/>
                    </x-confirm-action>
                </div>
            </div>
        @empty
            {{__('No maps in this story, yet...')}}
        @endforelse
    </div>


    <x-slot name="actions">
        <x-button wire:loading.disable
                  wire:click="$emit('openModal', 'game-engine.admin.maps.edit', {{json_encode(['isModal' => true, 'story_id' => $story->id])}})"
                  color="secondary"
        >{{__('Add Map')}}</x-button>
    </x-slot>
</x-card>
