<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

/** @noinspection PhpUndefinedMethodInspection */

namespace DefStudio\GameEngine\Database\Factories;

use DefStudio\GameEngine\Enums\MediaCollection;
use Illuminate\Database\Eloquent\Factories\Factory;
use DefStudio\GameEngine\Decorators\Tasks\DragAndDrop;
use DefStudio\GameEngine\Database\Factories\Concerns\HasMedia;
use DefStudio\GameEngine\Decorators\Tasks\MultipleChoiceQuestion;
use DefStudio\GameEngine\Database\Factories\Concerns\HasStorytelling;

use function game_engine;

class TaskFactory extends Factory
{
    use HasMedia;
    use HasStorytelling;

    public function modelName(): string
    {
        return game_engine()->taskClass();
    }

    public function definition(): array
    {
        return [
            'title' => fake()->sentence,
            'mission_id' => game_engine()->missionClass()::factory(),
            'type' => fake()->randomElement([MultipleChoiceQuestion::class, DragAndDrop::class]),
        ];
    }

    public function type(string $decorator): TaskFactory
    {
        return $this->state([
            'type' => $decorator,
        ]);
    }

    public function with_background_image(?string $path = null): TaskFactory
    {
        return $this->with_media(MediaCollection::background, $path);
    }
}
