@props(['run'])

@php
    use DefStudio\GameEngine\Decorators\Runs\PlayableStory;
    use DefStudio\GameEngine\Decorators\Runs\PlayableMap;
    use DefStudio\GameEngine\Decorators\Runs\PlayableMission;
    use DefStudio\GameEngine\Decorators\Runs\PlayableTask;
@endphp

@php($snapshot = $run->data->snapshot)

<div class="overflow-x-auto">
    <table x-data="{}" class="">
        <thead class="bg-gray-50 uppercase font-medium whitespace-nowrap tracking-wider text-left text-gray-500 text-xs">
        <tr>
            <th class="px-2 relative py-1" scope="col">
                {{'Activity'}}
            </th>
            <th class="px-2 relative py-1" scope="col">
                {{'Time Spent'}}
            </th>
            <x-game-engine::livewire.runs.view.table.award-headers class="px-2 relative py-1" :awards="$snapshot['awards'] ?? []"/>
        </tr>
        </thead>
        <tbody>
        @if($story = $snapshot['story'] ?? [])
            <x-game-engine::livewire.runs.view.table.row
                :label="__('Total')"
                :activity="$story"
                :run='$run'
                :awards="$snapshot['awards']"
                :state_key="PlayableStory::$state_key"
                bgcolor="bg-blue-800"
            />
        @endif

        @foreach($story['maps'] ?? [] as $map)
            <x-game-engine::livewire.runs.view.table.row
                :label="trans_choice('Map|Maps', 1)"
                :activity="$map"
                :run='$run'
                :awards="$snapshot['awards']"
                :state_key="PlayableMap::$state_key"
                bgcolor="bg-blue-600"
                padding="4"
            />

            @foreach($map['missions'] ?? [] as $mission)
                <x-game-engine::livewire.runs.view.table.row
                    :label="trans_choice('Mission|Missions', 1)"
                    :activity="$mission"
                    :run='$run'
                    :awards="$snapshot['awards']"
                    :state_key="PlayableMission::$state_key"
                    bgcolor="bg-blue-400"
                    padding="8"
                />

                @foreach($mission['tasks'] ?? [] as $task)
                    <x-game-engine::livewire.runs.view.table.row
                        :label="$task['type']::type_label()"
                        :activity="$task"
                        :run='$run'
                        :awards="$snapshot['awards']"
                        :state_key="PlayableTask::$state_key"
                        bgcolor="bg-blue-200"
                        padding="12"
                    />

                @endforeach
            @endforeach
        @endforeach

        </tbody>
    </table>
</div>
