@php
    use DefStudio\GameEngine\Actions\Runs\ComputeActivityTime;
    $locale = game_engine()->user()->locale ?? config('app.locale');
@endphp

@props(['label', 'activity', 'state_key', 'bgcolor', 'awards', 'run', 'padding' => 0])

@php($state = $run->get_state($state_key.".".$activity['id']))

<tr {{$attributes->class('odd:bg-white hover:odd:bg-gray-200 even:bg-gray-50 hover:even:bg-gray-200')}}>
    <td class="pl-{{$padding}} pr-2 py-1 font-medium whitespace-nowrap text-left text-gray-800 text-sm">
        <x-game-engine::elements.marked-box :shadow="false" :bgcolor="$bgcolor">
            {{$label}}: {{$activity['title']}}
        </x-game-engine::elements.marked-box>
    </td>
    <td class="px-2 py-1 font-medium whitespace-nowrap text-left text-gray-800 text-sm">
        @php($timer = ComputeActivityTime::run($state['timers'] ?? [])->cascade())
        @if($timer->seconds === 0)
            -
        @else
            {{$timer->locale($locale)->forHumans()}}
        @endif
    </td>
    <x-game-engine::livewire.runs.view.table.award-cells
        class="px-2 py-1 font-medium whitespace-nowrap text-left text-gray-800 text-sm"
        :awards="$awards" :state="$state"
    />
    {{$slot}}
</tr>
