<?php

use DefStudio\GameEngine\Models\Map;
use DefStudio\GameEngine\Models\Storytelling;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Decorators\Tasks\TaskDecorator;
use DefStudio\GameEngine\Enums\Feature;

?>

@if(!empty($this->images_to_preload))
    <div wire:ignore.self>
        <script defer>
            function preload_image(im_url) {
                let img = new Image();
                img.src = im_url;
            }

            setTimeout(function () {
                @foreach($this->images_to_preload as $image_url)
                preload_image("{{$image_url}}");
                @endforeach
            }, 1000);

        </script>
    </div>
    @php($this->images_to_preload = [])
@endif
