<?php

use DefStudio\GameEngine\Enums\Role;
use DefStudio\GameEngine\Enums\Feature;

?>


@props(['team' => null])

@php($user = game_engine()->user())

<?php
/** @var \DefStudio\GameEngine\Models\Team|null $team */
?>

<x-card>
    @if($team !== null)
        <x-slot name="header">
            {{__('Team: :name', ['name' => $team->name])}}
        </x-slot>


        <x-game-engine::teams.card.content :team="$team"/>

        @can('view', $team)
            <x-slot name="actions">
                <x-game-engine::teams.card.view-button :team="$team"/>
            </x-slot>
        @endcan

    @else

        <x-slot name="header">
            {{__('New Team')}}
        </x-slot>

        @can('create', \DefStudio\GameEngine\Models\Team::class)
            <x-slot name="actions">
                <x-game-engine::teams.card.create-button/>
            </x-slot>
        @endcan
    @endif
</x-card>
