<?php
/** @var \DefStudio\WiredTables\WiredTable $this */
?>

<script>
    document.addEventListener('livewire:load', function () {
        setInterval(function () {
            if (@this.filterValues.status === 'ongoing')
            {
                @this.$refresh();
            }
        }, 5000);
    });
</script>

@if($this->filterValues['status'] === 'ongoing')
    <div class="flex justify-center">
            <?php
            $should_allow_resume = false;

            if ($this->rows->every(fn (\DefStudio\GameEngine\Models\Run $run) => $run->is_paused())) {
                $should_allow_resume = true;
            }

            if (!empty($this->selectedIds()) && $this->selectedRows->every(fn (\DefStudio\GameEngine\Models\Run $run) => $run->is_paused())) {
                $should_allow_resume = true;
            }
            ?>

        @if($should_allow_resume)
            <x-button wire:click="resume">
                @empty($this->selectedIds())
                    {{__('Resume All')}}
                @else
                    {{__('Resume Selected')}}
                @endempty
            </x-button>
        @endif
    </div>
@endif