<?php

namespace DefStudio\GameEngine\Actions\Teams;

use DefStudio\Actions\Action;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Team;

/**
 * @method static Team run(Team $team, bool $authorize = true)
 */
class SaveTeam extends Action
{
    public function handle(Team $team, bool $authorize = true): Team
    {
        if ($authorize) {
            Gate::authorize('save', $team);
        }

        $team->save();

        return $team;
    }
}
