<?php

namespace DefStudio\GameEngine\Commands;

use Illuminate\Console\Command;
use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Actions\Runs\BuildSnapshot;
use Illuminate\Console\View\Components\TwoColumnDetail;

use function Laravel\Prompts\spin;

class RebuildSnapshotsCommand extends Command
{
    public $signature = 'game-engine:rebuild-snapshots {ids?}';

    public $description = 'rebuilds runs snapshots';

    public function handle(): int
    {
        $this->info('Rebuilding Snapshots');

        $ids = $this->argument('ids');

        $runs = $ids
            ? game_engine()->runQuery()->find(explode(',', $this->argument('ids')))
            : game_engine()->runQuery()->get();

        $runs->each(function(Run $run) {
            spin(function() use ($run) {
                BuildSnapshot::run($run);
            }, "Processing Run #$run->id");

            $this->twoColumnDetail()->render(
                "Run #$run->id",
                '<fg=green;options=bold>DONE</>'
            );
        });

        return self::SUCCESS;
    }

    public function twoColumnDetail(): TwoColumnDetail
    {
        return new TwoColumnDetail($this->getOutput());
    }

    public function fix_missing(array $target_array, array $element_to_check, string $key): array
    {
        $elements = data_get($target_array, $key);

        if (!collect($elements)->contains(fn(array $element) => $element['id'] === $element_to_check['id'])) {
            $elements[] = $element_to_check;
        }

        data_set($target_array, $key, $elements);

        return $target_array;
    }
}
