<?php

namespace DefStudio\GameEngine\DTO\Runs;

use Carbon\Carbon;
use DefStudio\GameEngine\Decorators\Runs\PlayableActivity;

class PauseInfo
{
    public function __construct(
        public readonly string $activity_type,
        public readonly string $activity_title,
        public readonly Carbon $time
    ) {}

    public static function from_activity(PlayableActivity $activity, ?Carbon $time = null): PauseInfo
    {
        return new PauseInfo(
            $activity->getMorphClass(),
            $activity->title,
            $time ?? now(),
        );
    }

    public static function from_array(array $pause_info): PauseInfo
    {
        return new PauseInfo(
            $pause_info['activity_type'],
            $pause_info['activity_title'],
            \carbon($pause_info['time']),
        );
    }

    public function to_array(): array
    {
        return [
            'activity_type' => $this->activity_type,
            'activity_title' => $this->activity_title,
            'time' => (string) $this->time,
        ];
    }
}
