<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Controllers;

use Illuminate\Contracts\View\View;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;

use function game_engine;

class MapsController
{
    use AuthorizesRequests;

    public function edit(int $story, int $map): View
    {
        $story = game_engine()->storyQuery()
            ->where('organization_id', game_engine()->user()->current_organization_id)
            ->orWhereNull('organization_id')
            ->findOrFail($story);
        $map = $story->maps()->findOrFail($map);

        $this->authorize('update', $story);

        return view('game-engine::admin.maps.edit', ['map' => $map]);
    }
}
