<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Http\Livewire\Runs\Concerns;

use DefStudio\GameEngine\Models\Run;
use DefStudio\GameEngine\Exceptions\RunnerException;
use DefStudio\GameEngine\Decorators\Runs\PlayableMap;
use DefStudio\GameEngine\Decorators\Runs\PlayableTask;
use DefStudio\GameEngine\Decorators\Runs\PlayableStory;
use DefStudio\GameEngine\Decorators\Runs\PlayableMission;

/**
 * @property-read Run $run
 * @property-read PlayableStory $story
 * @property-read PlayableMap $map
 * @property-read PlayableMission $mission
 * @property-read PlayableTask $task
 */
trait RetrievesActivities
{
    public function getRunProperty(): Run
    {
        /** @noinspection PhpIncompatibleReturnTypeInspection */
        return game_engine()->runQuery()->findOrFail($this->run_id);
    }

    public function getStoryProperty(): PlayableStory
    {
        return PlayableStory::build($this->run->story)->setup($this->run);
    }

    public function getMapProperty(): PlayableMap
    {
        return $this->story->playable_maps()
            ->values()
            ->get($this->current_map_index()) ?? throw RunnerException::no_active_map();
    }

    public function getMissionProperty(): PlayableMission
    {
        return $this->map->playable_missions()
            ->values()
            ->get($this->current_mission_index()) ?? throw RunnerException::no_active_mission();
    }

    public function getTaskProperty(): PlayableTask
    {
        return $this->mission->playable_tasks()
            ->values()
            ->get($this->current_task_index()) ?? throw RunnerException::no_active_task();
    }

    public function current_map_index(): int
    {
        return $this->run->get_state('current_map', -1);
    }

    public function is_map_active(): bool
    {
        return $this->current_map_index() >= 0;
    }

    public function current_mission_index(): int
    {
        return $this->run->get_state('current_mission', -1);
    }

    public function is_mission_active(): bool
    {
        return $this->current_mission_index() >= 0;
    }

    public function current_task_index(): int
    {
        return $this->run->get_state('current_task', -1);
    }

    protected function is_task_active(): bool
    {
        return $this->current_task_index() >= 0;
    }
}
