<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Providers;

use Illuminate\Support\Facades\Session;
use Illuminate\Support\ServiceProvider;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Illuminate\Database\Eloquent\ModelNotFoundException;
use DefStudio\GameEngine\Exceptions\OrganizationSwitchException;

class ExceptionServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        $handler = $this->app->make(ExceptionHandler::class);

        if (!method_exists($handler, 'map')) {
            return;
        }

        $handler->map(function(ModelNotFoundException $exception) {
            if (Session::get('switched_organization')) {
                return new OrganizationSwitchException;
            }

            return $exception;
        });

        $handler->ignore(OrganizationSwitchException::class);
    }
}
