<?php
/*
 * Copyright (c) 2023. DEF STUDIO S.R.L. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are prohibited without the prior written permission of DEF STUDIO S.R.L.
 * This software is provided "as is" and any express or implied warranties, including,
 * but not limited to, the implied warranties of merchantability and fitness for a
 * particular purpose are disclaimed. In no event shall DEF STUDIO S.R.L. be liable
 * for any direct, indirect, incidental, special, exemplary, or consequential damages
 * (including, but not limited to, procurement of substitute goods or services;
 * loss of use, data, or profits; or business interruption) however caused and on any
 * theory of liability, whether in contract, strict liability, or tort (including negligence or
 * otherwise) arising in any way out of the use of this software, even if advised of the
 * possibility of such damage.
 */

namespace DefStudio\GameEngine\Providers;

use Livewire\Livewire;
use Illuminate\Support\ServiceProvider;
use DefStudio\GameEngine\Http\Livewire\Runs\Runner;
use DefStudio\GameEngine\Http\Livewire\Awards\AwardList;
use DefStudio\GameEngine\Http\Livewire\Users\ResetPassword;
use DefStudio\GameEngine\Http\Livewire\Maps\Edit as EditMap;
use DefStudio\GameEngine\Http\Livewire\Runs\View as ViewRun;
use DefStudio\GameEngine\Http\Livewire\Tasks\Edit as EditTask;
use DefStudio\GameEngine\Http\Livewire\Teams\Edit as EditTeam;
use DefStudio\GameEngine\Http\Livewire\Users\Edit as EditUser;
use DefStudio\GameEngine\Http\Livewire\Runs\Table as RunsTable;
use DefStudio\GameEngine\Http\Livewire\Awards\Edit as EditAward;
use DefStudio\GameEngine\Http\Livewire\Maps\Editor as MapEditor;
use DefStudio\GameEngine\Http\Livewire\Stories\Edit as EditStory;
use DefStudio\GameEngine\Http\Livewire\Stories\Maps as StoryMaps;
use DefStudio\GameEngine\Http\Livewire\Teams\Table as TeamsTable;
use DefStudio\GameEngine\Http\Livewire\Users\Table as UsersTable;
use DefStudio\GameEngine\Http\Livewire\Missions\Edit as EditMission;
use DefStudio\GameEngine\Http\Livewire\Stories\Table as StoriesTable;
use DefStudio\GameEngine\Http\Livewire\Teams\Register as RegisterTeam;
use DefStudio\GameEngine\Http\Livewire\Runs\MissionModal as RunnerMission;
use DefStudio\GameEngine\Http\Livewire\Teams\UsersTable as TeamUsersTable;
use DefStudio\GameEngine\Http\Livewire\Organizations\Edit as EditOrganization;
use DefStudio\GameEngine\Http\Livewire\Storytellings\Edit as EditStorytelling;
use DefStudio\GameEngine\Http\Livewire\Teams\StoriesTable as TeamStoriesTable;
use DefStudio\GameEngine\Http\Livewire\Users\StoriesTable as UserStoriesTable;
use DefStudio\GameEngine\Http\Livewire\Organizations\Table as OrganizationsTable;
use DefStudio\GameEngine\Http\Livewire\Runs\StorytellingModal as RunnerStorytelling;
use DefStudio\GameEngine\Http\Livewire\Storytellings\Manager as StorytellingManager;
use DefStudio\GameEngine\Http\Livewire\Organizations\Register as RegisterOrganization;
use DefStudio\GameEngine\Http\Livewire\Organizations\UsersTable as OrganizationUsersTable;

class LivewireServiceProvider extends ServiceProvider
{
    public function boot(): void
    {
        Livewire::component('game-engine.users.reset-password', config('game-engine.livewire.components.users.reset_password', ResetPassword::class));
        Livewire::component('game-engine.admin.users.edit', config('game-engine.livewire.components.users.edit', EditUser::class));
        Livewire::component('game-engine.admin.users.table', config('game-engine.livewire.components.users.table', UsersTable::class));
        Livewire::component('game-engine.admin.users.stories.table', config('game-engine.livewire.components.users.stories-table', UserStoriesTable::class));
        Livewire::component('game-engine.admin.organizations.register', config('game-engine.livewire.components.organizations.register', RegisterOrganization::class));
        Livewire::component('game-engine.admin.organizations.table', config('game-engine.livewire.components.organizations.table', OrganizationsTable::class));
        Livewire::component('game-engine.admin.organizations.edit', config('game-engine.livewire.components.organizations.edit', EditOrganization::class));
        Livewire::component('game-engine.admin.organizations.users.table', config('game-engine.livewire.components.users.table', OrganizationUsersTable::class));
        Livewire::component('game-engine.admin.teams.register', config('game-engine.livewire.components.teams.register', RegisterTeam::class));
        Livewire::component('game-engine.admin.teams.table', config('game-engine.livewire.components.teams.table', TeamsTable::class));
        Livewire::component('game-engine.admin.teams.edit', config('game-engine.livewire.components.teams.edit', EditTeam::class));
        Livewire::component('game-engine.admin.teams.users.table', config('game-engine.livewire.components.teams.users-table', TeamUsersTable::class));
        Livewire::component('game-engine.admin.teams.stories.table', config('game-engine.livewire.components.teams.stories-table', TeamStoriesTable::class));
        Livewire::component('game-engine.admin.stories.table', config('game-engine.livewire.components.stories.table', StoriesTable::class));
        Livewire::component('game-engine.admin.stories.edit', config('game-engine.livewire.components.stories.edit', EditStory::class));
        Livewire::component('game-engine.admin.stories.maps', config('game-engine.livewire.components.stories.maps', StoryMaps::class));
        Livewire::component('game-engine.admin.maps.edit', config('game-engine.livewire.components.maps.edit', EditMap::class));
        Livewire::component('game-engine.admin.maps.editor', config('game-engine.livewire.components.maps.editor', MapEditor::class));
        Livewire::component('game-engine.admin.missions.edit', config('game-engine.livewire.components.missions.edit', EditMission::class));
        Livewire::component('game-engine.admin.tasks.edit', config('game-engine.livewire.components.tasks.edit', EditTask::class));
        Livewire::component('game-engine.admin.storytelling.manager', config('game-engine.livewire.components.storytelling.manager', StorytellingManager::class));
        Livewire::component('game-engine.admin.storytelling.edit', config('game-engine.livewire.components.storytelling.edit', EditStorytelling::class));
        Livewire::component('game-engine.admin.awards.award-list', config('game-engine.livewire.components.awards.list', AwardList::class));
        Livewire::component('game-engine.admin.awards.edit', config('game-engine.livewire.components.awards.edit', EditAward::class));
        Livewire::component('game-engine.admin.runs.table', config('game-engine.livewire.components.runs.table', RunsTable::class));
        Livewire::component('game-engine.admin.runs.view', config('game-engine.livewire.components.runs.view', ViewRun::class));
        Livewire::component('game-engine.runner', config('game-engine.livewire.components.runs.runner.main', Runner::class));
        Livewire::component('game-engine.runner.mission', config('game-engine.livewire.components.runs.runner.mission', RunnerMission::class));
        Livewire::component('game-engine.runner.storytelling', config('game-engine.livewire.components.runs.runner.storytelling', RunnerStorytelling::class));
    }
}
