<x-app-layout>
    <x-slot name="header">
        @isset($user)
            {{__('Edit User :name', ['name' => $user->name])}}
        @else
            {{__('Create User')}}
        @endisset
    </x-slot>

    <x-slot name="actions">
        <x-link class="ml-auto" :href="game_engine()->back_url()" icon="arrow-sm-left" color="secondary" size="sm">{{__('Back')}}</x-link>
    </x-slot>

    <x-container>
        <livewire:game-engine.admin.users.edit :user="$user ?? \game_engine()->userQuery()->make()"/>
    </x-container>

    @if(isset($user) && $user->get_role_in_organization(game_engine()->user()->current_organization) === \DefStudio\GameEngine\Enums\Role::player)
        <x-container>
            @feature(\DefStudio\GameEngine\Enums\Feature::user_stories)
            <x-card class="mt-4 subscribers-table">
                <x-slot name="header" class="!bg-gray-200 font-bold uppercase">{{trans_choice('Story|Stories', 2)}}</x-slot>
                <livewire:game-engine.admin.users.stories.table :subscriber="$user"/>
            </x-card>
            @endfeature
        </x-container>
    @endif
</x-app-layout>
