<?php

/** @noinspection PhpUnhandledExceptionInspection */

namespace DefStudio\GameEngine\Actions\Missions;

use DefStudio\Actions\Action;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Gate;
use DefStudio\GameEngine\Models\Mission;
use DefStudio\GameEngine\Enums\MediaCollection;
use DefStudio\GameEngine\Events\Missions\MissionPlaceholderImageUpdated;

/**
 * @method static void run(Mission $mission, UploadedFile $placeholder_image_file)
 */
class StorePlaceholderImage extends Action
{
    public function handle(Mission $mission, UploadedFile $placeholder_image_file): void
    {
        Gate::authorize('update', $mission);

        $mission->addMedia($placeholder_image_file)
            ->toMediaCollection(MediaCollection::placeholder->name);

        MissionPlaceholderImageUpdated::dispatch($mission);
    }
}
