@php
    use DefStudio\GameEngine\Enums\MediaCollection
    /** @var \DefStudio\GameEngine\Http\Livewire\Missions\Edit $this */
@endphp


@php($cover_url = $this->mission->getFirstMediaUrl(MediaCollection::cover))
@php($placeholder_url = $this->mission->getFirstMediaUrl(MediaCollection::placeholder))
@php($placeholder_active_url = $this->mission->getFirstMediaUrl(MediaCollection::placeholder_active))
@php($placeholder_completed_url = $this->mission->getFirstMediaUrl(MediaCollection::placeholder_completed))
<x-card :collapsed="!empty($placeholder_url)">
    <x-slot name="header" class="!bg-gray-200 font-bold uppercase">
        <x-icon name="photo"/>&nbsp;{{trans_choice('Image|Images', 2)}}
    </x-slot>

    <div class="grid grid-cols-1 gap-6">
        <x-game-engine::livewire.image_field
                id="cover-image"
                model="cover_image"
                :label="trans_choice('Cover Image|Cover Images', 1)"
                :uploaded-url="$cover_url"
                :helper="__('SVG, PNG or JPG')"
                remove-method="remove_cover_image"
        />

        <x-game-engine::livewire.image_field
                id="placeholder-image"
                model="placeholder_image"
                :label="trans_choice('Placeholder Image|Placeholder Images', 1)"
                :uploaded-url="$placeholder_url"
                :helper="__('SVG, PNG or JPG')"
                remove-method="remove_placeholder_image"
        />

        <x-game-engine::livewire.image_field
                id="placeholder-active-image"
                model="placeholder_active_image"
                :label="trans_choice('Placeholder Image (when active)|Placeholder Images (when active)', 1)"
                :uploaded-url="$placeholder_active_url"
                :helper="__('SVG, PNG or JPG')"
                remove-method="remove_placeholder_active_image"
        />

        <x-game-engine::livewire.image_field
                id="placeholder-completed-image"
                model="placeholder_completed_image"
                :label="trans_choice('Placeholder Image (when completed)|Placeholder Images (when completed)', 1)"
                :uploaded-url="$placeholder_completed_url"
                :helper="__('SVG, PNG or JPG')"
                remove-method="remove_placeholder_completed_image"
        />
    </div>
</x-card>
