<?php

namespace DefStudio\GameEngine\Exceptions;

use Exception;
use DefStudio\GameEngine\Attributes\ParentScope;

class ScopeException extends Exception
{
    public static function no_scope_detected(string $class): ScopeException
    {
        return new ScopeException("Model [$class] has no methods with #[".class_basename(ParentScope::class).'] attribute');
    }

    public static function multiple_scope_detected(string $class): ScopeException
    {
        return new ScopeException("Model [$class] has more than one method with #[".class_basename(ParentScope::class).'] attribute');
    }
}
