<?php
use DefStudio\GameEngine\Enums\Role;
?>

<div  {{$attributes->class('mt-4')}}>
    @can('create', Role::master)
        <x-button color="secondary"
                  class="mr-auto"
                  wire:click="$emit('openModal', 'game-engine.admin.users.edit', {{json_encode(['isModal' => true, 'creating_role' => Role::master->value])}})"
                  @click="$wire.set('role_under_creation', '{{Role::master->value}}')"
        >{{__('Add Master')}}</x-button>
    @endcan

    @can('create', Role::player)
        <x-button color="secondary"
                  class="mr-auto"
                  wire:click="$emit('openModal', 'game-engine.admin.users.edit', {{json_encode(['isModal' => true, 'creating_role' => Role::player->value])}})"
                  @click="$wire.set('role_under_creation', '{{Role::player->value}}')"
        >{{__('Add Player')}}</x-button>
    @endcan
</div>
