@feature(\DefStudio\GameEngine\Enums\Feature::organization_admin_registration_url)
@if(game_engine()->role(\DefStudio\GameEngine\Enums\Role::super_admin))
    @php($organization_registration_expiration = config('game-engine.organizations.register_organization.url_validity_days') ? today()->addDays(config('game-engine.organizations.register_organization.url_validity_days'))->endOfDay() : null)
    @php($organization_registration_url = \Illuminate\Support\Facades\URL::signedRoute('game-engine.register-organization', expiration: $organization_registration_expiration))

    <x-container {{$attributes}} x-data="{
            url: '{!! $organization_registration_url !!}',
            copy(){
                this.$refs.url.select();
                this.$refs.url.setSelectionRange(0, 99999);
                navigator.clipboard.writeText(this.$refs.url.value);
                this.$refs.url.setSelectionRange(0, 0);
            }
        }">
        <div>
            <span class="font-bold">{{__('Organization Registration URL')}}</span>
            <button x-cloak x-show="window.isSecureContext" class="border rounded-md shadow focus-visible:outline-none inline-flex items-center justify-center hover:bg-gray-200 ml-2 px-2 py-1" @click="copy">{{__('copy')}}</button>
            <input class="border-0 bg-transparent w-full focus:ring-0" x-ref="url" x-model="url"/>
        </div>

    </x-container>
@endif
@endfeature